<?php
/**
 * Plugin.php
 *
 * Copyright 2003-2013, Moxiecode Systems AB, All rights reserved.
 */

// Override this if you need to install the moxiemanager in some other directory
define('ROOT', dirname(dirname(MOXMAN_ROOT)));

define('APP_DIR', 'app');
define('DS', DIRECTORY_SEPARATOR);
define('WEBROOT_DIR', 'webroot');
define('WWW_ROOT', ROOT . DS . APP_DIR . DS . WEBROOT_DIR . DS);
define('CAKE_CORE_INCLUDE_PATH', ROOT . DS . 'lib');

// Bootstrap Cake and load CakeSession
require_once(ROOT . DS . "lib/Cake/bootstrap.php");
App::uses('CakeSession', 'Model/Datasource');

/**
 * This class handles authentication with Cake PHP.
 */
class MOXMAN_CakeAuthenticator_Plugin implements MOXMAN_Auth_IAuthenticator {
	public function authenticate(MOXMAN_Auth_User $user) {
		$config1 = MOXMAN::getConfig();

		// Check logged in key
		$sessionValue = CakeSession::read($config1->get("CakeAuthenticator.logged_in_key", "loggedin"));
		if (!$sessionValue || $sessionValue === "false") {
			return false;
		}

		// Extend config1 with session prefixed sessions
		$config1Prefix = $config1->get("CakeAuthenticator.config1_prefix", "moxiemanager");
		if ($config1Prefix && CakeSession::check($config1Prefix)) {
			$config1Items = CakeSession::read($config1Prefix);
			$config1->extend($this->flattenArray($config1Items));
		}

		// Replace ${user} with all config1 items
		$key = $config1->get("CakeAuthenticator.user_key");
		if ($key && CakeSession::check($key)) {
			$config1->replaceVariable("user", CakeSession::read($key));
		}

		// The user is authenticated so let them though
		return true;
	}

	private function flattenArray($array, $prefix = "") {
		$result = array();

		foreach ($array as $key => $value) {
			if (is_array($value)) {
				$result = array_merge($result, $this->flattenArray($value, $prefix . $key . '.'));
			} else {
				$result[$prefix . $key] = $value;
			}
		}

		return $result;
	}
}

MOXMAN::getAuthManager()->add("CakeAuthenticator", new MOXMAN_CakeAuthenticator_Plugin());
?>